<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

namespace Altum;

use Altum\Models\Campaign;
use Altum\Models\Flow;
use Altum\Models\PersonalNotification;

defined('ALTUMCODE') || die();

class CustomHooks {

    public static function user_finished_registration($data = []) {
        $plan_settings = json_decode($data['plan_settings']);

        if($plan_settings->notification_handlers_email_limit > 0) {
            db()->insert('notification_handlers', [
                'user_id' => $data['user_id'],
                'type' => 'email',
                'name' => $data['email'],
                'settings' => json_encode([
                    'email' => $data['email']
                ]),
                'datetime' => get_date(),
            ]);
        }
    }

    public static function user_delete($data = []) {

        /* Delete the potentially uploaded files on preference settings */
        if($data['user']->preferences->white_label_logo_light) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_logo_light, 'users');
        }

        if($data['user']->preferences->white_label_logo_dark) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_logo_dark, 'users');
        }

        if($data['user']->preferences->white_label_favicon) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_favicon, 'users');
        }

        $user_id = $data['user']->user_id;

        /* Flows deletion */
        $result = database()->query("SELECT `flow_id` FROM `flows` WHERE `user_id` = {$user_id}");

        while($flow = $result->fetch_object()) {
            (new Flow())->delete($flow->flow_id);
        }

        /* Campaigns deletion */
        $result = database()->query("SELECT `campaign_id` FROM `campaigns` WHERE `user_id` = {$user_id}");

        while($campaign = $result->fetch_object()) {
            (new Campaign())->delete($campaign->campaign_id);
        }

        /* Personal notifications deletion */
        $result = database()->query("SELECT `personal_notification_id` FROM `personal_notifications` WHERE `user_id` = {$user_id}");

        while($personal_notification = $result->fetch_object()) {
            (new PersonalNotification())->delete($personal_notification->personal_notification_id);
        }

    }

    public static function user_payment_finished($data = []) {
        extract($data);

        db()->where('user_id', $user->user_id)->update('users', [
            'pusher_sent_push_notifications_current_month' => 0,
            'pusher_campaigns_current_month' => 0,
        ]);

    }

}
