<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We want to salute you and welcome you to our website community!<br /><br /><a href="{{URL}}">Visit our homepage</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'A user just deleted his account from the website!<br /><br />All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',

    'global.emails.user_new_subscriber.subject' => 'New subscriber for \'{{WEBSITE_NAME}}\' - {{WEBSITE_TITLE}}',
    'global.emails.user_new_subscriber.body' => '<strong>{{SUBSCRIBER_IP}}</strong> has subscribed to your <strong>{{WEBSITE_NAME}}</strong> (<strong>{{WEBSITE_URL}}}</strong>) website push notifications.<br /><br />{{DATA}} Greetings from {{WEBSITE_TITLE}}.',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.websites_limit' => '%s websites',
    'global.plan_settings.subscribers_limit' => '%s subscribers',
    'global.plan_settings.segments_limit' => '%s segments',
    'global.plan_settings.personal_notifications_limit' => '%s personal notifications',
    'global.plan_settings.personal_notifications_limit_help' => 'Personal notifications are like campaigns, but for one person only. Used for testing, dedicated notifications or API.',
    'global.plan_settings.rss_automations_limit' => '%s RSS automations',
    'global.plan_settings.rss_automations_limit_help' => 'Parse RSS feeds and send push notifications to your subscribers automatically.',
    'global.plan_settings.recurring_campaigns_limit' => '%s recurring campaigns',
    'global.plan_settings.recurring_campaigns_limit_help' => 'Deliver recurring campaigns to your users every day, week or month.',
    'global.plan_settings.flows_limit' => '%s flows',
    'global.plan_settings.campaigns_per_month_limit' => '%s campaigns / month',
    'global.plan_settings.sent_push_notifications_per_month_limit' => '%s sent notifications / month',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.subscribers_logs_retention' => '%s days subscribers logs retention',
    'global.plan_settings.analytics_is_enabled' => 'Analytics',
    'global.plan_settings.analytics_is_enabled_help' => 'Advanced analytics & tracking for subscribers and push notifications.',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.removable_branding_is_enabled' => 'Removable branding',
    'global.plan_settings.removable_branding_is_enabled_help' => 'All the branding will be removed from branded resources.',
    'global.plan_settings.custom_branding_is_enabled' => 'Custom branding',
    'global.plan_settings.custom_branding_is_enabled_help' => 'Customize any brand-able resources with ease.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.notification_handlers_limit' => 'Multiple notification handlers',
    'global.plan_settings.notification_handlers_email_limit' => '%s email handlers',
    'global.plan_settings.notification_handlers_webhook_limit' => '%s webhook handlers',
    'global.plan_settings.notification_handlers_slack_limit' => '%s Slack handlers',
    'global.plan_settings.notification_handlers_discord_limit' => '%s Discord handlers',
    'global.plan_settings.notification_handlers_microsoft_teams_limit' => '%s Microsoft Teams handlers',
    'global.plan_settings.notification_handlers_twilio_limit' => '%s SMS handlers',
    'global.plan_settings.notification_handlers_twilio_call_limit' => '%s Phone call handlers',
    'global.plan_settings.notification_handlers_telegram_limit' => '%s Telegram handlers',
    'global.plan_settings.notification_handlers_whatsapp_limit' => '%s Whatsapp handlers',
    'global.plan_settings.notification_handlers_x_limit' => '%s X handlers',
    'global.plan_settings.notification_handlers_push_subscriber_id_limit' => '%s Push subscribers handlers',


    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.subheader.desktop' => 'Click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'Tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'Tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'Click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your dynamic QR code links.',
    'domains.create' => 'Connect domain',
    'domains.domain_id' => 'Domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.input.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.input.host' => 'Domain or subdomain',
    'domains.input.custom_index_url' => 'Custom index URL',
    'domains.input.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.input.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.input.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the websites pixels codes associated with the domain will stop working. This action cannot be undone.',


    'subscribers.title' => 'Subscribers',
    'subscribers.menu' => 'Subscribers',
    'subscribers.breadcrumb' => 'Subscribers',
    'subscribers.header' => 'Subscribers',
    'subscribers.subheader' => 'All your active websites subscribers.',
    'subscribers.import' => 'Import subscribers',
    'subscribers.subscribed_on_url' => 'Subscribed on URL',
    'subscribers.no_data' => 'There are no subscribers yet',
    'subscribers.no_data_help' => 'Start by subscribing yourself or wait for your users to subscribe.',
    'subscribers.subscribed' => 'Subscribed',
    'subscribers.unsubscribed' => 'Unsubscribed',
    'subscribers.permission_denied' => 'Permission denied',
    'subscribers.displayed_notification' => 'Displayed notification',
    'subscribers.clicked_notification' => 'Clicked notification',
    'subscribers.closed_notification' => 'Closed notification',
    'subscribers.manually_deleted' => 'Manually deleted',
    'subscribers.push_notification_sent' => 'Push notification delivered',
    'subscribers.expired_deleted' => 'Expired deleted',
    'subscribers.push_notification_failed' => 'Push notification failed',
    'subscribers.custom_parameters' => '%s custom parameters',


    'subscribers_statistics.breadcrumb' => 'Statistics',
    'subscribers_statistics.title' => 'Subscribers statistics',
    'subscribers_statistics.title_dynamic' => 'Subscribers statistics - %s',
    'subscribers_statistics.menu' => 'Subscribers statistics',
    'subscribers_statistics.header_dynamic' => '%s statistics',
    'subscribers_statistics.header' => 'Subscribers statistics',
    'subscribers_statistics.link' => 'Statistics',
    'subscribers_statistics.overview' => 'Overview',
    'subscribers_statistics.overview_help' => '',
    'subscribers_statistics.data_preview' => 'Data preview',
    'subscribers_statistics.data_preview_info' => 'Widgets data is based on the last %s entries. Click View more to see all the widget data.',
    'subscribers_statistics.country_help' => 'Discover the countries that your subscribers are from.',
    'subscribers_statistics.continent_code_help' => 'Discover the continents that your subscribers are from.',
    'subscribers_statistics.city_name_from_country' => 'Cities of %s',
    'subscribers_statistics.city_name_help' => 'Discover the cities that your subscribers are from.',
    'subscribers_statistics.os' => 'Operating systems',
    'subscribers_statistics.os_help' => 'Discover the operating systems that your subscribers are using.',
    'subscribers_statistics.browser' => 'Browsers',
    'subscribers_statistics.browser_help' => 'Discover the browsers that your subscribers are using.',
    'subscribers_statistics.language' => 'Languages',
    'subscribers_statistics.language_help' => 'Discover the browser languages that your subscribers are having.',
    'subscribers_statistics.device' => 'Devices',
    'subscribers_statistics.device_help' => 'Discover the devices that your subscribers are using.',
    'subscribers_statistics.subscribed_on_url' => 'Subscribed on URL',
    'subscribers_statistics.subscribed_on_url_help' => 'Discover where you got your subscribers from.',
    'subscribers_statistics.no_data' => 'There are no statistics available for this date range',
    'subscribers_statistics.no_data_help' => 'Wait for new subscribers or change your date range.',


    'subscriber.title' => 'Subscriber - %s',
    'subscriber.menu' => 'Subscriber',
    'subscriber.breadcrumb' => 'Subscriber',
    'subscriber.header' => '%s subscriber',
    'subscriber.subheader' => 'Here are all the details about your subscriber.',
    'subscriber.logs' => 'Subscriber logs',
    'subscriber.stats' => 'Stats',
    'subscriber.advanced' => 'Advanced',
    'subscriber.endpoint' => 'Subscription endpoint URL',
    'subscriber.keys.p256dh' => 'p256dh key',
    'subscriber.keys.auth' => 'Auth key',
    'subscriber.custom_parameters' => 'Custom parameters',
    'subscriber.custom_parameter_add' => 'Add parameter',
    'subscriber.custom_parameter_key' => 'Key',
    'subscriber.custom_parameter_value' => 'Value',
    'subscriber.send_push_notification' => 'Send push notification',
    'subscriber.subscriber_id' => 'Subscriber ID',


    'subscriber_update.breadcrumb' => 'Edit subscriber',
    'subscriber_update.title' => 'Edit subscriber',
    'subscriber_update.header' => 'Edit subscriber',


    'subscribers_import.breadcrumb' => 'Import subscribers',
    'subscribers_import.title' => 'Import subscribers',
    'subscribers_import.header' => 'Import subscribers',
    'subscribers_import.file' => 'CSV file',
    'subscribers_import.file_help' => 'The CSV file must contain: <code>endpoint</code>, <code>p256dh</code>, <code>auth</code> columns. Optional columns: <code>ip</code>, <code>city_name</code>, <code>country_code</code>, <code>continent_code</code>, <code>os_name</code>, <code>browser_name</code>, <code>browser_language</code>, <code>subscribed_on_url</code>, <code>datetime</code>',
    'subscribers_import.success_message' => '%s subsribers have been successfully imported.',


    'subscribers_logs.title' => 'Subscribers logs',
    'subscribers_logs.menu' => 'Subscribers logs',
    'subscribers_logs.breadcrumb' => 'Subscribers logs',
    'subscribers_logs.header' => 'Subscribers logs',
    'subscribers_logs.subheader' => 'All the event logs of your push subscribers.',
    'subscribers_logs.no_data' => 'There are no subscriber logs yet',
    'subscribers_logs.no_data_help' => 'Come back once you have subscribers activity.',


    'campaigns.title' => 'Campaigns',
    'campaigns.menu' => 'Campaigns',
    'campaigns.breadcrumb' => 'Campaigns',
    'campaigns.header' => 'Campaigns',
    'campaigns.create' => 'Create campaign',
    'campaigns.campaign' => 'Campaign',
    'campaigns.subheader' => 'All the sent notification campaigns to your subscribers.',
    'campaigns.variables' => 'You can use also use all the dynamic variables & the spintax format as mentioned in the title input.',
    'campaigns.no_data' => 'There are no sent campaigns yet',
    'campaigns.no_data_help' => 'Start by creating & sending your first push notifications campaign.',
    'campaigns.notifications' => 'Notifications',
    'campaigns.total_push_notifications' => 'Total push notifications',
    'campaigns.total_sent_push_notifications' => 'Sent notifications',
    'campaigns.total_displayed_push_notifications' => 'Displayed notifications',
    'campaigns.total_clicked_push_notifications' => 'Clicked notifications',
    'campaigns.total_closed_push_notifications' => 'Closed notifications',
    'campaigns.status.draft' => 'Draft',
    'campaigns.status.scheduled' => 'Scheduled',
    'campaigns.status.processing' => 'Processing',
    'campaigns.status.sent' => 'Sent',
    'campaigns.title_help' => 'It is recommended not to go over 30-60 characters. Depending on the device, it will be automatically truncated if too long.',
    'campaigns.description_help' => 'It is recommended not to go over 40-80 characters. Depending on the device, it will be automatically truncated if too long.',
    'campaigns.scheduling' => 'Scheduling',
    'campaigns.is_scheduled' => 'Schedule campaign',
    'campaigns.scheduled_datetime' => 'Scheduled send datetime',
    'campaigns.utm' => 'UTM Parameters',
    'campaigns.utm_medium' => 'Medium',
    'campaigns.utm_medium_placeholder' => 'ex: link, banner, email, social',
    'campaigns.utm_campaign' => 'Campaign',
    'campaigns.utm_campaign_placeholder' => 'ex: spring_sale_2024, black_friday',
    'campaigns.utm_source' => 'Source',
    'campaigns.utm_source_placeholder' => 'ex: newsletter, bing, google, youtube',
    'campaigns.utm_preview' => 'UTM preview',
    'campaigns.utm_preview_help' => 'This query parameter will be appended to your destination URLs.',
    'campaigns.advanced' => 'Advanced',
    'campaigns.buttons' => 'Buttons',
    'campaigns.buttons_info' => 'Keep in mind that some platforms do not display the action buttons.',
    'campaigns.button_x' => 'Button %s',
    'campaigns.is_silent' => 'Silent notification',
    'campaigns.is_silent_help' => 'Do not trigger the sound and vibration of the notification.',
    'campaigns.is_auto_hide' => 'Auto hide notification',
    'campaigns.is_auto_hide_help' => 'Some platforms auto hide the notification after a few seconds unless you specify otherwise.',
    'campaigns.ttl' => 'Time to live',
    'campaigns.ttl_help' => 'How much time the notification provider will wait for the device to come online and display the notification before it drops it.',
    'campaigns.ttl_help2' => 'Lower values usually set for time sensitive notifications. For example, if you run a 1 day discount campaign - set this value to 1 day maximum.',
    'campaigns.urgency' => 'Urgency',
    'campaigns.urgency_help' => 'Set the urgency of which the push provider will deliver the notification to the specific devices.',
    'campaigns.urgency.low' => 'Low',
    'campaigns.urgency.normal' => 'Normal',
    'campaigns.urgency.high' => 'High',
    'campaigns.image_help' => 'The hero image of the push notification. 3:2 aspect ratio is recommended. Not all devices and browsers will display this image.',
    'campaigns.segment' => 'Segment',
    'campaigns.segment.saved' => 'Saved segments',
    'campaigns.segment.all' => 'All subscribers',
    'campaigns.segment.custom' => 'Custom CSV list',
    'campaigns.segment.filter' => 'Filtered data',
    'campaigns.subscribers_ids' => 'Push Subscribers IDs',
    'campaigns.subscribers_ids_placeholder' => '1,2,3',
    'campaigns.subscribers_ids_help' => 'Comma separated values.',
    'campaigns.last_sent_datetime' => 'Last sent notification',
    'campaigns.save' => 'Save draft',
    'campaigns.send' => 'Send campaign',
    'campaigns.success_message.save' => '%s campaign was saved. You can come back later and send it.',
    'campaigns.success_message.scheduled' => '%1$s campaign has been scheduled to be sent in %2$s.',
    'campaigns.success_message.send' => '%s campaign will start to be processed.',
    'campaigns.error_message.processing' => 'You can not view or update a campaign while it is processing.',


    'campaign.title' => 'Campaign - %s',
    'campaign.menu' => 'Campaign',
    'campaign.breadcrumb' => 'Campaign',
    'campaign.header' => '%s campaign',
    'campaign.subheader' => 'Here are all the details about your campaign.',
    'campaign.logs' => 'Campaign logs',


    'campaign_create.breadcrumb' => 'Send a new campaign',
    'campaign_create.title' => 'Send a new campaign',
    'campaign_create.header' => 'Send a new campaign',


    'campaign_update.breadcrumb' => 'Update campaign',
    'campaign_update.title' => 'Update campaign',
    'campaign_update.header' => 'Update campaign',


    'segments.title' => 'Segments',
    'segments.menu' => 'Segments',
    'segments.breadcrumb' => 'Segments',
    'segments.header' => 'Segments',
    'segments.create' => 'Create segment',
    'segments.campaign' => 'Campaign',
    'segments.subheader' => 'Create and manage segments/groups of your subscribers for easy access.',
    'segments.no_data' => 'There are no sent segments yet',
    'segments.no_data_help' => 'Start by creating your first subscribers segment.',
    'segments.segment' => 'Segment',
    'segments.type.custom' => 'Custom CSV list',
    'segments.type.filter' => 'Filtered data',
    'segments.subscribers_ids' => 'Push Subscribers IDs',
    'segments.subscribers_ids_placeholder' => '1,2,3',
    'segments.subscribers_ids_help' => 'Comma separated values.',
    'segments.custom_parameter_key' => 'Custom parameter key',
    'segments.custom_parameter_value' => 'Custom parameter value',
    'segments.languages' => 'Browser languages',
    'segments.operating_systems' => 'Operating systems',
    'segments.browsers' => 'Browsers',
    'segments.cities_placeholder' => 'Tokyo, New York, Istanbul',
    'segments.cities_help' => 'Comma separated values.',


    'segment_create.breadcrumb' => 'Create a new segment',
    'segment_create.title' => 'Create a new segment',
    'segment_create.header' => 'Create a new segment',


    'segment_update.breadcrumb' => 'Update segment',
    'segment_update.title' => 'Update segment',
    'segment_update.header' => 'Update segment',


    'flows.title' => 'Flows',
    'flows.menu' => 'Flows',
    'flows.breadcrumb' => 'Flows',
    'flows.header' => 'Flows',
    'flows.create' => 'Create flow',
    'flows.flow' => 'Flow',
    'flows.subheader' => 'Create an automated flow of notifications for your subscribers.',
    'flows.no_data' => 'There are no automated flows yet',
    'flows.no_data_help' => 'Start by creating your first subscribers flow.',
    'flows.wait_time' => 'Wait time',
    'flows.wait_time_help' => 'How much time (from the moment a user is subscribed) to wait until flow is triggered.',
    'flows.is_enabled' => 'Flow is active',


    'flow.title' => 'Flow - %s',
    'flow.menu' => 'Flow',
    'flow.breadcrumb' => 'Flow',
    'flow.header' => '%s flow',
    'flow.subheader' => 'Here are all the details about your flow.',


    'flow_create.breadcrumb' => 'Create a new flow',
    'flow_create.title' => 'Create a new flow',
    'flow_create.header' => 'Create a new flow',


    'flow_update.breadcrumb' => 'Update flow',
    'flow_update.title' => 'Update flow',
    'flow_update.header' => 'Update flow',


    'personal_notifications.title' => 'Personal notifications',
    'personal_notifications.menu' => 'Personal notifications',
    'personal_notifications.breadcrumb' => 'Personal notifications',
    'personal_notifications.header' => 'Personal notifications',
    'personal_notifications.create' => 'Create personal notification',
    'personal_notifications.personal_notification' => 'Personal notification',
    'personal_notifications.subscriber_id' => 'Subscriber ID',
    'personal_notifications.sent_datetime' => 'Sent datetime',
    'personal_notifications.subheader' => 'All the dedicated notifications sent to one subscriber per entry.',
    'personal_notifications.no_data' => 'There are no sent personal notifications yet',
    'personal_notifications.no_data_help' => 'Start by creating & sending your first personal push notification.',
    'personal_notifications.save' => 'Save draft',
    'personal_notifications.send' => 'Send personal notification',
    'personal_notifications.success_message.save' => '%s personal notification was saved. You can come back later and send it.',
    'personal_notifications.success_message.scheduled' => '%1$s personal notification has been scheduled to be sent in %2$s.',
    'personal_notifications.success_message.sent' => '%s personal notification has been processed.',
    'personal_notifications.error_message.subscriber_id' => 'The subscriber ID entered is incorrect.',


    'personal_notification_create.breadcrumb' => 'Send a new personal notification',
    'personal_notification_create.title' => 'Send a new personal notification',
    'personal_notification_create.header' => 'Send a new personal notification',


    'personal_notification_update.breadcrumb' => 'Update personal notification',
    'personal_notification_update.title' => 'Update personal notification',
    'personal_notification_update.header' => 'Update personal notification',


    'rss_automation.title' => 'RSS automation - %s',
    'rss_automation.menu' => 'RSS automation',
    'rss_automation.breadcrumb' => 'RSS automation',
    'rss_automation.header' => '%s automation',
    'rss_automation.subheader' => 'Here are all the details about your RSS automation.',


    'rss_automations.title' => 'RSS automations',
    'rss_automations.menu' => 'RSS automations',
    'rss_automations.breadcrumb' => 'RSS automations',
    'rss_automations.header' => 'RSS automations',
    'rss_automations.create' => 'Create RSS automation',
    'rss_automations.rss_automation' => 'RSS automation',
    'rss_automations.subheader' => 'Automatically parse and send web push notifications to your subscribers based on RSS feeds.',
    'rss_automations.no_data' => 'There are no RSS feeds yet',
    'rss_automations.no_data_help' => 'Start by attaching your first RSS feed & automate push notifications.',
    'rss_automations.rss_url' => 'RSS feed URL',
    'rss_automations.rss_url_placeholder' => 'https://example.com/rss.xml',
    'rss_automations.rss_url_help' => 'The full URL to your website\'s valid RSS feed.',
    'rss_automations.check_interval_seconds' => 'Check interval',
    'rss_automations.check_interval_seconds_help' => 'How often should the RSS feed be checked.',
    'rss_automations.items' => 'items',
    'rss_automations.items_count' => 'Number of RSS feed items',
    'rss_automations.items_count_help' => 'Specify the number of unique recent items from your RSS feed to send notifications for.',
    'rss_automations.campaigns_delay' => 'Delay between push campaigns',
    'rss_automations.campaigns_delay_help' => 'Set the time interval to wait between sending each new push campaign.',
    'rss_automations.last_check_datetime' => 'Last checked datetime',
    'rss_automations.next_check_datetime' => 'Next checked datetime',
    'rss_automations.rss' => 'RSS settings',
    'rss_automations.is_enabled' => 'RSS automation is active',
    'rss_automations.total_campaigns' => 'Total campaigns',
    'rss_automations.error_message.invalid_rss_url' => 'We could not parse your RSS feed. Make sure to enter a valid RSS feed URL.',


    'rss_automation_create.breadcrumb' => 'Create RSS automation',
    'rss_automation_create.title' => 'Create RSS automation',
    'rss_automation_create.header' => 'Create RSS automation',


    'rss_automation_update.breadcrumb' => 'Update RSS automation',
    'rss_automation_update.title' => 'Update RSS automation',
    'rss_automation_update.header' => 'Update RSS automation',


    'recurring_campaign.title' => 'Recurring campaign - %s',
    'recurring_campaign.menu' => 'Recurring campaign',
    'recurring_campaign.breadcrumb' => 'Recurring campaign',
    'recurring_campaign.header' => '%s recurring campaign',
    'recurring_campaign.subheader' => 'Here are all the details about your recurring campaign.',


    'recurring_campaigns.title' => 'Recurring campaigns',
    'recurring_campaigns.menu' => 'Recurring campaigns',
    'recurring_campaigns.breadcrumb' => 'Recurring campaigns',
    'recurring_campaigns.header' => 'Recurring campaigns',
    'recurring_campaigns.create' => 'Create recurring campaign',
    'recurring_campaigns.recurring_campaign' => 'Recurring campaign',
    'recurring_campaigns.subheader' => 'Create campaigns that run automatically every day, week or month based on your needs.',
    'recurring_campaigns.no_data' => 'There are no recurring campaigns yet',
    'recurring_campaigns.no_data_help' => 'Start by setting up your first automated recurring campaign.',
    'recurring_campaigns.last_run_datetime' => 'Last run datetime',
    'recurring_campaigns.next_run_datetime' => 'Next run datetime',
    'recurring_campaigns.recurring_campaign_settings' => 'Recurring campaign settings',
    'recurring_campaigns.frequency' => 'Campaign frequency',
    'recurring_campaigns.frequency.daily' => 'Daily',
    'recurring_campaigns.frequency.weekly' => 'Weekly',
    'recurring_campaigns.frequency.monthly' => 'Monthly',
    'recurring_campaigns.week_days' => 'Days of the week',
    'recurring_campaigns.month_days' => 'Days of the month',
    'recurring_campaigns.time' => 'Time',
    'recurring_campaigns.is_enabled' => 'Recurring campaign is active',
    'recurring_campaigns.total_campaigns' => 'Total campaigns',


    'recurring_campaign_create.breadcrumb' => 'Create recurring campaign',
    'recurring_campaign_create.title' => 'Create recurring campaign',
    'recurring_campaign_create.header' => 'Create recurring campaign',


    'recurring_campaign_update.breadcrumb' => 'Update recurring campaign',
    'recurring_campaign_update.title' => 'Update recurring campaign',
    'recurring_campaign_update.header' => 'Update recurring campaign',


    'websites.title' => 'Websites',
    'websites.menu' => 'Websites',
    'websites.breadcrumb' => 'Websites',
    'websites.header' => 'Websites',
    'websites.subheader' => 'Your attached websites for push subscribers and notifications.',
    'websites.create' => 'Add website',
    'websites.install_code' => 'Install code',
    'websites.no_data' => 'There are no websites added for now',
    'websites.no_data_help' => 'Start by connecting your first website.',
    'websites.website' => 'Website',
    'websites.subscriber' => 'Subscriber',
    'websites.subscribers' => 'Subscribers',
    'websites.subscribed' => 'Subscribed',
    'websites.unsubscribed' => 'Unsubscribed',
    'websites.total_subscribers' => 'Total subscribers',
    'websites.host' => 'Domain or subdomain',
    'websites.path' => 'Path',

    'websites.input.domain_id' => 'Custom domain',
    'websites.input.domain_id_help' => 'Use a custom domain for your pixel code URL. Helpful to bypass ad-blockers.',
    'websites.input.host_help' => 'You can use any of the following formats: <strong>domain.com</strong>, <strong>sub.domain.com</strong> or <strong>domain.com/path</strong>.',
    'websites.input.advanced' => 'Advanced',
    'websites.input.notifications' => 'Notifications',
    'websites.input.notifications_help' => 'Get notified when people subscribe to your website\'s push notifications.',
    'websites.input.is_enabled' => 'Website push notification system is active',
    'websites.input.customizations' => 'Customizations',
    'websites.input.icon' => 'Push notifications icon',
    'websites.input.icon_help' => 'The image that you want to display as your badge and icon when sending push notifications, recommended 1:1 ratio for the icon, maximum of 512x512.',
    'websites.input.ip_storage_is_enabled' => 'Subscribers IP storage is enabled',
    'websites.input.ip_storage_is_enabled_help' => 'We recommend only enabling this if you got consent from your users to store their IPs.',
    'websites.input.branding' => 'Branding',
    'websites.input.branding.name' => 'Branding name',
    'websites.input.branding.name_help' => 'Leave empty to have the default site branding.',
    'websites.input.branding.url' => 'Branding URL',
    'websites.input.keys_help' => 'These are the unique VAPID values. Only edit those values if you know what you are doing.',
    'websites.input.keys.public_key' => 'Public key',
    'websites.input.keys.private_key' => 'Private key',
    'websites.error_message.keys' => 'Invalid public & private key combination.',
    'websites.error_message.blacklisted_domain' => 'This domain is blacklisted.',


    'websites.simple_notification' => 'New push subscriber for the \'%1$s\' (%2$s) website.%3$sView details: %4$s 🔗.',
    'websites.push_notification.title' => 'New push subscriber',
    'websites.push_notification.description' => '%1$s (%2$s)',


    'website.title' => 'Website - %s',
    'website.menu' => 'Website',
    'website.breadcrumb' => 'Website',
    'website.header' => '%s website',
    'website.subheader' => 'Here are all the details about your website.',
    'website.advanced' => 'Advanced',
    'website.public_key' => 'Public key',
    'website.private_key' => 'Private key',
    'website.total_sent_campaigns' => 'Total sent campaigns',
    'website.website_id' => 'Website ID',


    'website_create.breadcrumb' => 'Add a new website',
    'website_create.title' => 'Add a new website',
    'website_create.header' => 'Add a new website',
    'website_create.info' => 'You can configure the website further after its creation.',


    'website_update.breadcrumb' => 'Edit website',
    'website_update.title' => 'Edit website',
    'website_update.header' => 'Edit website',


    'website_subscribe_button.breadcrumb' => 'Subscribe button configuration',
    'website_subscribe_button.title' => 'Subscribe button configuration',
    'website_subscribe_button.menu' => 'Subscribe button',
    'website_subscribe_button.header' => 'Subscribe button configuration',
    'website_subscribe_button.preview' => 'Button preview',
    'website_subscribe_button.install' => 'Install button',
    'website_subscribe_button.install_help' => 'Copy and paste the following HTML code in your website where you want the button to be displayed.',
    'website_subscribe_button.settings' => 'Button settings',
    'website_subscribe_button.input.is_enabled' => 'Subscribe button is active',
    'website_subscribe_button.input.is_enabled_help' => 'Display an unobtrusive opt-in/status type button on your website to allow your visitors to subscribe or unsubscribe.',


    'website_subscribe_widget.breadcrumb' => 'Subscribe widget configuration',
    'website_subscribe_widget.title' => 'Subscribe widget configuration',
    'website_subscribe_widget.menu' => 'Subscribe widget',
    'website_subscribe_widget.header' => 'Subscribe widget configuration',
    'website_subscribe_widget.preview' => 'Widget preview',
    'website_subscribe_widget.settings' => 'Widget settings',
    'website_subscribe_widget.html_info' => 'This field accepts the usage of <code>span</code> HTML tag along with the <code>style</code> attribute.',
    'website_subscribe_widget.html_info_tooltip' => 'Available CSS for the style attribute: color,font-weight,font-style,text-decoration,font-family,background-color,text-transform,margin,padding,text-align',
    'website_subscribe_widget.input.is_enabled' => 'Subscribe widget is active',
    'website_subscribe_widget.input.is_enabled_help' => 'Display an opt-in widget on your website to ask your visitors to subscribe.',
    'website_subscribe_widget.input.is_enabled_help2' => 'This widget will only show if the user is not subscribed.',
    'website_subscribe_widget.input.subscribe' => 'Subscribe text',
    'website_subscribe_widget.input.unsubscribe' => 'Unsubscribe text',
    'website_subscribe_widget.input.successful_subscription' => 'Successful subscription text',
    'website_subscribe_widget.input.successful_unsubscription' => 'Successful unsubscription text',
    'website_subscribe_widget.input.permission_denied' => 'Permission denied configuration',
    'website_subscribe_widget.input.subscribe_button' => 'Subscribe button',
    'website_subscribe_widget.input.close_button' => 'Close button',
    'website_subscribe_widget.input.image_url' => 'Image URL',
    'website_subscribe_widget.input.image_alt' => 'Image alt',
    'website_subscribe_widget.input.subscribed_success_url' => 'Success URL',
    'website_subscribe_widget.input.subscribed_success_url_help' => 'Where to redirect the user after a successful subscription. Leave empty to disable.',
    'website_subscribe_widget.input.unsubscribed_success_url' => 'Successful unsubscription URL',
    'website_subscribe_widget.input.unsubscribed_success_url_help' => 'Where to redirect the user after a successful unsubscription. Leave empty to disable.',
    'website_subscribe_widget.input.permission_denied_refresh_button' => 'Refresh button',
    'website_subscribe_widget.input.customize' => 'Customize',
    'website_subscribe_widget.input.font' => 'Font',
    'website_subscribe_widget.input.font_inherit' => 'Inherit from website',
    'website_subscribe_widget.input.colors' => 'Colors',
    'website_subscribe_widget.input.title_color' => 'Title color',
    'website_subscribe_widget.input.description_color' => 'Description color',
    'website_subscribe_widget.input.background_color' => 'Background color',
    'website_subscribe_widget.input.subscribe_button_text_color' => 'Subscribe button text color',
    'website_subscribe_widget.input.subscribe_button_background_color' => 'Subscribe button background color',
    'website_subscribe_widget.input.close_button_text_color' => 'Close button text color',
    'website_subscribe_widget.input.close_button_background_color' => 'Close button background color',
    'website_subscribe_widget.input.internal_padding' => 'Internal padding',
    'website_subscribe_widget.input.borders' => 'Borders',
    'website_subscribe_widget.input.border_width' => 'Border width',
    'website_subscribe_widget.input.border_color' => 'Border color',
    'website_subscribe_widget.input.border_radius' => 'Border radius',
    'website_subscribe_widget.input.border_radius_straight' => 'Straight',
    'website_subscribe_widget.input.border_radius_rounded' => 'Rounded',
    'website_subscribe_widget.input.border_radius_highly_rounded' => 'Highly rounded',
    'website_subscribe_widget.input.border_radius_round' => 'Round',
    'website_subscribe_widget.input.display_shadow' => 'Display shadow',
    'website_subscribe_widget.input.display_shadow_help' => 'Enable or disable the shadow around the edges of the notification',
    'website_subscribe_widget.input.animations' => 'Animations',
    'website_subscribe_widget.input.animation' => 'Animation',
    'website_subscribe_widget.input.animation_interval' => 'Animation interval',
    'website_subscribe_widget.input.animation_heartbeat' => 'Heartbeat',
    'website_subscribe_widget.input.animation_bounce' => 'Bounce',
    'website_subscribe_widget.input.animation_flash' => 'Flash',
    'website_subscribe_widget.input.animation_pulse' => 'Pulse',
    'website_subscribe_widget.input.hover_animation' => 'Hover animation',
    'website_subscribe_widget.input.hover_animation_fast_scale_up' => 'Fast scale up',
    'website_subscribe_widget.input.hover_animation_slow_scale_up' => 'Slow scale up',
    'website_subscribe_widget.input.hover_animation_fast_scale_down' => 'Fast scale down',
    'website_subscribe_widget.input.hover_animation_slow_scale_down' => 'Slow scale down',
    'website_subscribe_widget.input.on_animation' => 'Entrance animation',
    'website_subscribe_widget.input.on_animation_fadeIn' => 'Fade in',
    'website_subscribe_widget.input.on_animation_slideInUp' => 'Slide in up',
    'website_subscribe_widget.input.on_animation_slideInDown' => 'Slide in down',
    'website_subscribe_widget.input.on_animation_zoomIn' => 'Zoom in',
    'website_subscribe_widget.input.on_animation_bounceIn' => 'Bounce in',
    'website_subscribe_widget.input.off_animation' => 'Exit animation',
    'website_subscribe_widget.input.off_animation_fadeOut' => 'Fade out',
    'website_subscribe_widget.input.off_animation_slideOutUp' => 'Slide out up',
    'website_subscribe_widget.input.off_animation_slideOutDown' => 'Slide out down',
    'website_subscribe_widget.input.off_animation_zoomOut' => 'Zoom out',
    'website_subscribe_widget.input.off_animation_bounceOut' => 'Bounce out',
    'website_subscribe_widget.input.display' => 'Display',
    'website_subscribe_widget.input.direction' => 'Direction',
    'website_subscribe_widget.input.direction_ltr' => 'Left to right',
    'website_subscribe_widget.input.direction_rtl' => 'Right to left',
    'website_subscribe_widget.input.display_duration' => 'Display duration',
    'website_subscribe_widget.input.display_duration_help' => 'Set -1 to display forever.',
    'website_subscribe_widget.input.display_position' => 'Display position',
    'website_subscribe_widget.input.display_position_top_left' => 'Top Left',
    'website_subscribe_widget.input.display_position_top_center' => 'Top Center',
    'website_subscribe_widget.input.display_position_top_right' => 'Top Right',
    'website_subscribe_widget.input.display_position_middle_left' => 'Middle Left',
    'website_subscribe_widget.input.display_position_middle_center' => 'Middle Center',
    'website_subscribe_widget.input.display_position_middle_right' => 'Middle Right',
    'website_subscribe_widget.input.display_position_bottom_left' => 'Bottom Left',
    'website_subscribe_widget.input.display_position_bottom_center' => 'Bottom Center',
    'website_subscribe_widget.input.display_position_bottom_right' => 'Bottom Right',
    'website_subscribe_widget.input.display_position_top' => 'Top',
    'website_subscribe_widget.input.display_position_bottom' => 'Bottom',
    'website_subscribe_widget.input.display_position_top_floating' => 'Top Floating',
    'website_subscribe_widget.input.display_position_bottom_floating' => 'Bottom Floating',
    'website_subscribe_widget.input.display_branding' => 'Display branding',
    'website_subscribe_widget.input.triggers' => 'Triggers',
    'website_subscribe_widget.input.trigger_all_pages' => 'Trigger on all pages',
    'website_subscribe_widget.input.trigger_all_pages_help' => 'Where should the notification show?',
    'website_subscribe_widget.input.trigger_add' => 'Add new trigger',
    'website_subscribe_widget.input.trigger_type_exact' => 'Exact match',
    'website_subscribe_widget.input.trigger_type_not_exact' => 'Does not match exact',
    'website_subscribe_widget.input.trigger_type_contains' => 'Contains',
    'website_subscribe_widget.input.trigger_type_not_contains' => 'Does not contain',
    'website_subscribe_widget.input.trigger_type_starts_with' => 'Starts with',
    'website_subscribe_widget.input.trigger_type_not_starts_with' => 'Does not start with',
    'website_subscribe_widget.input.trigger_type_ends_with' => 'Ends with',
    'website_subscribe_widget.input.trigger_type_not_ends_with' => 'Does not end with',
    'website_subscribe_widget.input.trigger_type_page_contains' => 'Page Contains',
    'website_subscribe_widget.input.trigger_type_exact_placeholder' => 'Full URL - ex: https://domain.com',
    'website_subscribe_widget.input.trigger_type_not_exact_placeholder' => 'Full URL - ex: https://domain.com',
    'website_subscribe_widget.input.trigger_type_contains_placeholder' => 'Part of the URL - ex: /product/12345',
    'website_subscribe_widget.input.trigger_type_not_contains_placeholder' => 'Part of the URL - ex: /product/12345',
    'website_subscribe_widget.input.trigger_type_starts_with_placeholder' => 'Part of the URL - ex: https://domain.com/product',
    'website_subscribe_widget.input.trigger_type_not_starts_with_placeholder' => 'Part of the URL - ex: https://domain.com/product',
    'website_subscribe_widget.input.trigger_type_ends_with_placeholder' => 'Part of the URL - ex: /product/12345',
    'website_subscribe_widget.input.trigger_type_not_ends_with_placeholder' => 'Part of the URL - ex: /product/12345',
    'website_subscribe_widget.input.trigger_type_page_contains_placeholder' => 'Text inside of the website',
    'website_subscribe_widget.input.display_delay_type_after_close' => 'Display delay type after closing the notification',
    'website_subscribe_widget.input.display_delay_type_after_close_help' => 'If the user manually closed the notification, you can set a specific delay to wait before the notification will display again.',
    'website_subscribe_widget.input.display_delay_type_after_close_time_on_site' => 'Time on site',
    'website_subscribe_widget.input.display_delay_type_after_close_pageviews' => 'Pageviews',
    'website_subscribe_widget.input.display_trigger' => 'Display trigger',
    'website_subscribe_widget.input.display_trigger_delay' => 'Delay',
    'website_subscribe_widget.input.display_trigger_time_on_site' => 'Time on site',
    'website_subscribe_widget.input.display_trigger_time_on_site_help' => 'Total time spent on the triggered pages across one browsing session.',
    'website_subscribe_widget.input.display_trigger_pageviews' => 'Pageviews',
    'website_subscribe_widget.input.display_trigger_inactivity' => 'Page inactivity',
    'website_subscribe_widget.input.display_trigger_scroll' => 'Page scroll',
    'website_subscribe_widget.input.display_trigger_click' => 'Mouse click',
    'website_subscribe_widget.input.display_trigger_click_help' => 'CSS selector: #id or .class of the element you want to target.',
    'website_subscribe_widget.input.display_trigger_hover' => 'Mouse hover',
    'website_subscribe_widget.input.display_trigger_hover_help' => 'CSS selector: #id or .class of the element you want to target.',
    'website_subscribe_widget.input.display_trigger_exit_intent' => 'Exit Intent',
    'website_subscribe_widget.input.display_frequency' => 'Display frequency',
    'website_subscribe_widget.input.display_frequency_all_time' => 'All the time',
    'website_subscribe_widget.input.display_frequency_once_per_session' => 'Once per session',
    'website_subscribe_widget.input.display_frequency_once_per_browser' => 'Once per browser',
    'website_subscribe_widget.input.targeting' => 'Targeting',
    'website_subscribe_widget.input.display_targeting_help' => 'Select who should see this notification. Leave empty for all.',
    'website_subscribe_widget.input.display_languages' => 'Browser languages',
    'website_subscribe_widget.input.display_operating_systems' => 'Operating systems',
    'website_subscribe_widget.input.display_browsers' => 'Browsers',
    'website_subscribe_widget.input.display_mobile' => 'Display on small screens',
    'website_subscribe_widget.input.display_mobile_help' => 'Whether or not to display the notification on when pixels available are smaller than 768px.',
    'website_subscribe_widget.input.display_desktop' => 'Display on large screens',
    'website_subscribe_widget.input.display_desktop_help' => 'Whether or not to display the notification on when pixels available are bigger than 768px.',


    'website_install_code_modal.header' => 'Install code',
    'website_install_code_modal.first.header' => '1. First step',
    'website_install_code_modal.first.subheader' => 'Download the <strong>%1$s</strong> file from below and upload it into your website root. After uploading, the <strong>%2$s</strong> file must be accessible.',
    'website_install_code_modal.second.header' => '2. Second step',
    'website_install_code_modal.second.subheader' => 'Copy and paste the following JS code snippet before the end of the <code>head</code> tag of your website.',
    'website_install_code_modal.second.copy' => 'Copy pixel',
    'website_install_code_modal.second.copied' => 'Copied!',


    'notification_handlers.title' => 'Notification handlers',
    'notification_handlers.menu' => 'Notification handlers',
    'notification_handlers.breadcrumb' => 'Notification handlers',
    'notification_handlers.header' => 'Notification handlers',
    'notification_handlers.subheader' => 'How do you want to get notified when important things are happening?',
    'notification_handlers.create' => 'Create notification handler',

    'notification_handlers.input.name' => 'Name',
    'notification_handlers.input.type' => 'Notification type',
    'notification_handlers.input.type_x' => 'X tweet',
    'notification_handlers.input.type_email' => 'Email',
    'notification_handlers.input.type_webhook' => 'Webhook',
    'notification_handlers.input.type_slack' => 'Slack',
    'notification_handlers.input.type_microsoft_teams' => 'Microsoft Teams',
    'notification_handlers.input.type_discord' => 'Discord',
    'notification_handlers.input.type_telegram' => 'Telegram',
    'notification_handlers.input.type_twilio' => 'SMS',
    'notification_handlers.input.type_twilio_call' => 'Phone call',
    'notification_handlers.input.type_whatsapp' => 'Whatsapp',
    'notification_handlers.input.type_push_subscriber_id' => 'Push notification',
    'notification_handlers.input.push_subscriber_id' => 'Push subscriber',
    'notification_handlers.input.push_subscriber_id_help' => 'Select one device that you have subscribed with.',
    'notification_handlers.input.email' => 'Email',
    'notification_handlers.input.email_help' => 'Receive email notifications.',
    'notification_handlers.input.webhook' => 'Webhook URL',
    'notification_handlers.input.webhook_help' => 'Receive POST calls notifications to your specified webhook URL.',
    'notification_handlers.input.slack' => 'Slack webhook URL',
    'notification_handlers.input.slack_help' => 'Receive Slack notifications for your specified Slack channel via webhooks. <a href="https://slack.com/apps/A0F7XDUAZ-incoming-webhooks" target="_blank">Get Slack webhook URL</a>.',
    'notification_handlers.input.discord' => 'Discord webhook URL',
    'notification_handlers.input.discord_help' => 'Receive Discord notifications for your specified Discord channel via webhooks.',
    'notification_handlers.input.microsoft_teams' => 'Microsoft Teams webhook URL',
    'notification_handlers.input.microsoft_teams_help' => 'Receive Microsoft Teams notifications for your specified channel via webhooks. <a href="https://learn.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook?tabs=dotnet" target="_blank">Get Microsoft Teams webhook URL</a>.',
    'notification_handlers.input.telegram' => 'Telegram API Token',
    'notification_handlers.input.telegram_help' => 'The token for the HTTP API that you received after creating the bot on Telegram.',
    'notification_handlers.input.telegram_chat_id' => 'Telegram Chat ID',
    'notification_handlers.input.telegram_chat_id_help' => 'Where the bot should send the messages to.',
    'notification_handlers.input.twilio' => 'Phone number',
    'notification_handlers.input.twilio_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.input.twilio_call' => 'Phone number',
    'notification_handlers.input.twilio_call_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.input.whatsapp' => 'Whatsapp number',
    'notification_handlers.input.whatsapp_help' => 'Example of valid phone number: 15558675310. Only numbers.',
    'notification_handlers.input.x_consumer_key' => 'X consumer key',
    'notification_handlers.input.x_consumer_secret' => 'X consumer secret',
    'notification_handlers.input.x_access_token' => 'X access token',
    'notification_handlers.input.x_access_token_secret' => 'X access token secret',
    'notification_handlers.input.is_enabled' => 'Notification handler is active',
    'notification_handlers.no_data' => 'There are no notification handlers for now',
    'notification_handlers.no_data_help' => 'Start by creating your first notification handler.',


    'notification_handler_create.breadcrumb' => 'Create a new notification handler',
    'notification_handler_create.title' => 'Create a new notification handler',
    'notification_handler_create.header' => 'Create a new notification handler',


    'notification_handler_update.breadcrumb' => 'Edit notification handler',
    'notification_handler_update.title' => 'Edit notification handler',
    'notification_handler_update.header' => 'Edit notification handler',


    'pixel.widget.title' => 'Get notified on discount campaigns 🔥',
    'pixel.widget.description' => 'Once a month, no spam, unsubscribe at any time.',
    'pixel.widget.subscribe_button' => 'Subscribe',
    'pixel.widget.close_button' => 'Not now',
    'pixel.widget.subscribed_title' => 'Welcome ✨',
    'pixel.widget.subscribed_description' => 'Thank you for subscribing!',
    'pixel.widget.permission_denied_title' => 'Push notifications denied permission',
    'pixel.widget.permission_denied_description' => 'If you wish to subscribe - please reset your browser\'s notification permissions.',
    'pixel.widget.permission_denied_refresh_button' => 'Refresh page',
    'pixel.widget.permission_denied_close_button' => 'Close',


    'pixel.button.title' => 'Subscribe for discounts 🔥',
    'pixel.button.description' => 'Unsubscribe at any time, no spam.',
    'pixel.button.subscribed_title' => 'Welcome ✨',
    'pixel.button.subscribed_description' => 'Thank you for subscribing!',
    'pixel.button.unsubscribe_title' => 'Unsubscribe',
    'pixel.button.unsubscribe_description' => 'Click to unsubscribe.',
    'pixel.button.unsubscribed_title' => 'Bye bye 👋',
    'pixel.button.unsubscribed_description' => 'You can subscribe back at any time!',
    'pixel.button.permission_denied_title' => 'Browser denied permission',
    'pixel.button.permission_denied_description' => 'Reset your browser\'s notification permissions to subscribe.',


    'help.menu' => 'Help',
    'help.breadcrumb' => 'Help',
    'help.title' => '%s - Help',
    'help.pros' => 'Pros',
    'help.cons' => 'Cons',

    'help.introduction.title' => 'Introduction',
    'help.introduction.menu' => 'Introduction',
    'help.introduction.header' => 'Introduction',
    'help.introduction.p1' => 'This is the documentation for %s, a fully-featured & easy-to-use web push notifications platform that allows you to easily connect with your users.',
    'help.introduction.p2' => 'These help pages detail how some of the features work and how you can benefit from them.',
    'help.introduction.p3' => 'If you need more information or have any questions, please contact us.',

    'help.platforms_browsers_support.title' => 'Platforms & browsers',
    'help.platforms_browsers_support.menu' => 'Platforms & browsers',
    'help.platforms_browsers_support.header' => 'Platforms & browsers support',
    'help.platforms_browsers_support.p1' => 'All major and modern browsers support web push notifications. This applies to mobile devices, tablets and desktop computers.',
    'help.platforms_browsers_support.info1' => 'iOS requires the user to first add the website to the home screen and subscribe within the app.',
    'help.platforms_browsers_support.info2' => 'Users can not subscribe from Incognito browser windows, webviews or in-app browsers (ex: TikTok browser, Instagram browser).',

    'help.custom_parameters.title' => 'Custom parameters',
    'help.custom_parameters.menu' => 'Custom parameters',
    'help.custom_parameters.header' => 'Custom parameters',
    'help.custom_parameters.p1' => 'To identify visitors that subscribe via custom parameters, follow these steps:',
    'help.custom_parameters.p2' => 'This is useful for websites with membership systems. When users log in, you can specify their identifier (ex: email, user_id, name) with our tracking code.',
    'help.custom_parameters.p3' => 'This helps you understand user behavior and identify any issues they encounter.',
    'help.custom_parameters.p4' => 'Add <code>data-custom-parameters=\'{JSON_PARAMETERS_HERE}\'</code> as shown in the example:',
    'help.custom_parameters.p5' => 'If this parameter is provided, you will see the <i class="fas fa-fw fa-fingerprint text-primary"></i> icon active next to the subscriber details on the Subscribers and Subscriber page, indicating they have been identified with custom parameters.',

    'help.custom_button.title' => 'Custom button',
    'help.custom_button.menu' => 'Custom button',
    'help.custom_button.header' => 'Custom button',
    'help.custom_button.p1' => 'If you wish to integrate a custom subscribe/unsubscribe button with your own design, you can.',
    'help.custom_button.p2' => 'These are the exposed pixel features that you can use in your JS code to do a custom integration:',
    'help.custom_button.p3' => 'Here is a sample code integration that uses these custom JS functions:',

    'help.faq.title' => 'Frequently asked questions',
    'help.faq.menu' => 'FAQ',
    'help.faq.header' => 'Frequently asked questions',
    'help.faq.p' => 'Here you can find the answers to the common questions.',

    'help.faq.q1.header' => 'Notification shows as delivered & displayed but did not actually display',
    'help.faq.q1.subheader' => 'In most cases, this happens due to device or browser settings where the notifications are turned off or due to the fact that you use a "Do not disturb" / "Focus" mode on your device.',
    'help.faq.q1.r1' => 'Turn off "Do not disturb" or "Focus mode" on your device.',
    'help.faq.q1.r2' => 'Go to your device\'s settings and make sure you have notifications enabled for the browser that is subscribed.',
    'help.faq.q1.r3' => 'Make sure the subscribed browser is open / running.',

    'help.faq.q2.header' => 'Notification shows as delivered but was not received & displayed',
    'help.faq.q2.subheader' => 'There are numerous reasons for this issue. Here are the most common things to check.',
    'help.faq.q2.r1' => 'Make sure the device is running and has internet connection.',
    'help.faq.q2.r2' => 'Make sure the device does not have airplane mode or power saving mode enabled.',
    'help.faq.q2.r3' => 'Make sure the subscribed browser is open / running.',
    'help.faq.q2.r4' => 'Make sure the subscribed browser has notifications enabled in the device\'s settings.',
    'help.faq.q2.r5' => 'Make sure the subscribed browser is still subscribed and the permissions for the subscribed website did not reset.',
    'help.faq.q2.subheader2' => 'There are also other reasons outside of your control that might trigger this issue.',
    'help.faq.q2.r6' => 'Subscribed browser has a bug in the current browser version.',
    'help.faq.q2.r7' => 'Push service (from each browser) may be unavailable or decided to not send the notification.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Get to learn & understand new things with the help of curated your blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',
    'plan.button.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.input.default_results_per_page' => 'Default results per page',
    'account_preferences.input.default_order_type' => 'Default results order',
    'account_preferences.input.default_order_by_x' => '%s default order by',
    'account_preferences.input.white_label_title' => 'White label title',
    'account_preferences.input.white_label_logo_light' => 'White label logo light',
    'account_preferences.input.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.input.white_label_favicon' => 'White label favicon',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',

    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payments.payment_processor' => 'Processor',
    'account_payments.payments.total_amount' => 'Total amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments found',

    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.input.access' => '%s permissions',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',

    'login.form.twofa_token' => 'Two-factor token',
    'login.form.remember_me' => 'Remember me',
    'login.form.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.form.login' => 'Login',
    'login.form.verify' => 'Verify',

    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost password',
    'login.display.resend_activation' => 'Resend activation',
    'login.display.facebook' => 'Sign in with Facebook',
    'login.display.google' => 'Sign in with Google',
    'login.display.twitter' => 'Sign in with X',
    'login.display.discord' => 'Sign in with Discord',
    'login.display.linkedin' => 'Sign in with LinkedIn',
    'login.display.microsoft' => 'Sign in with Microsoft',

    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',

    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.form.register' => 'Register',

    'register.display.login' => 'Already have an account? %s',
    'register.display.login_help' => 'Sign in',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'Check your email for the activation link of your account.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.websites_header' => 'Latest websites',
    'dashboard.subscribers_header' => 'Latest subscribers',
    'dashboard.campaigns_header' => 'Latest campaigns',
    'dashboard.total_websites' => '%s websites',
    'dashboard.total_subscribers' => '%s subscribers',
    'dashboard.total_campaigns' => '%s campaigns',
    'dashboard.total_sent_push_notifications' => '%s sent notifications',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Web Push Notifications',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'Web Push Notifications',
    'index.subheader' => 'Fully-featured web push notifications within minutes. <br /> <strong>🚀 %s push notifications sent</strong> to subscribers.',
    'index.subheader2' => 'Supports all modern browsers',
    'index.register' => 'Sign up',
    'index.hero_image_alt' => 'Screenshot of the app dashboard',
    'index.notification_example_image_alt' => 'Screenshot of the app sending web push notifications',
    'index.subscribers_image_alt' => 'Screenshot of the app subscribers management page',
    'index.campaigns_image_alt' => 'Screenshot of the app push campaign overview page',
    'index.flows_image_alt' => 'Screenshot of the app flows management page',
    'index.rss_automations_image_alt' => 'Screenshot of the app RSS automations management page',
    'index.segments_image_alt' => 'Screenshot of the app segments management and editing page',
    'index.widget_image_alt' => 'Screenshot of the app prompt widget example for users to subscribe',
    'index.button_image_alt' => 'Screenshot of the app embeddable action button for users to subscribe',
    'index.advanced_image_alt' => 'Screenshot of the app advanced settings for websites page',
    'index.export_image_alt' => 'Screenshot of the app data exporting feature and analytics',
    'index.custom_parameters_image_alt' => 'Screenshot of the app subscribers custom parameter tracking feature',
    'index.domains_image_alt' => 'Screenshot of the app custom domains for personalized pixel JS codes link',

    'index.api.name' => 'API system',
    'index.api.header' => 'Developer ready',
    'index.api.subheader' => 'Fully featured & easy to use API system for developers.',

    'index.push_notifications.name' => 'Web push notifications',
    'index.push_notifications.header' => 'Highly configurable notifications',
    'index.push_notifications.subheader' => 'We offer a comprehensive and feature-rich configurator for all the push notifications you send.',
    'index.push_notifications.image' => 'Attach image to notifications',
    'index.push_notifications.url' => 'Custom URL on click',
    'index.push_notifications.buttons' => '2x custom action buttons',
    'index.push_notifications.dynamic' => 'Dynamic titles & descriptions',
    'index.push_notifications.others' => 'Silent notifications, Urgency configurator, Time to live (TTL)',

    'index.subscribers.name' => 'Subscribers',
    'index.subscribers.header' => 'Comprehensive subscriber journey',
    'index.subscribers.subheader' => 'Get to understand your subscribers by monitoring their push activities.',
    'index.subscribers.location' => 'Continent, Country & City',
    'index.subscribers.platforms' => 'OS, Browser, Device',
    'index.subscribers.referrer' => 'Referred URL page',
    'index.subscribers.statistics' => 'Push notifications statistics',
    'index.subscribers.logs' => 'Logs of all actions on notifications',

    'index.campaigns.name' => 'Campaigns',
    'index.campaigns.header' => 'Fully featured push campaigns',
    'index.campaigns.subheader' => 'Prepare, schedule & send push campaigns to your subscribers with ease.',
    'index.campaigns.spintax' => 'Spintax support for titles and descriptions',
    'index.campaigns.custom_parameters' => 'Use collected custom parameters for titles and descriptions',
    'index.campaigns.segments' => 'Send campaigns to a specific group of subscribers',
    'index.campaigns.statistics' => 'Detailed insights after the campaign is sent',

    'index.flows.name' => 'Flows',
    'index.flows.header' => 'Automated series of notifications',
    'index.flows.subheader' => 'Set up automated notification flows for new subscribers and watch your engagement grow. Here are just a few examples.',
    'index.flows.one' => 'After 5 minutes: Welcome notification',
    'index.flows.two' => 'After 1 day: In-depth tutorial notification',
    'index.flows.three' => 'After 7 days: Free 30 day trial code',
    'index.flows.four' => 'After 37 days: Upgrade to paid plan 30% discount code',

    'index.rss_automations.name' => 'RSS automations',
    'index.rss_automations.header' => 'RSS to Push Notifications',
    'index.rss_automations.subheader' => 'Automatically trigger push notification to be sent when your RSS feed gets new content.',
    'index.rss_automations.one' => 'Fully featured push notification',
    'index.rss_automations.two' => 'Configurable RSS feed checks',
    'index.rss_automations.three' => 'Spread out RSS feed notifications with delays',
    'index.rss_automations.four' => 'Dynamic usage of RSS feed title, description & URLs',

    'index.recurring_campaigns.name' => 'Recurring campaigns',
    'index.recurring_campaigns.header' => 'Campaigns on autopilot',
    'index.recurring_campaigns.subheader' => 'Schedule & automatically send campaigns based on the time of day, week or day of the month.',
    'index.recurring_campaigns.one' => 'Hour and minute scheduling',
    'index.recurring_campaigns.two' => 'Select days of the week',
    'index.recurring_campaigns.three' => 'Select days of the month',


    'index.segments.name' => 'Segments',
    'index.segments.header' => 'Custom subscriber groups',
    'index.segments.subheader' => 'Create segments of subscribers to easily access different type of users from your audience.',
    'index.segments.custom' => 'Custom CSV subscribers',
    'index.segments.region' => 'Continents & countries filters',
    'index.segments.device' => 'Filter by mobile, tablets & desktops',
    'index.segments.os' => 'Filter by any major OS',
    'index.segments.browsers' => 'Categorize by browsers',
    'index.segments.languages' => 'Filter by browser languages',

    'index.browsers.header' => 'Platforms & browsers support',
    'index.browsers.subheader' => 'All major operating systems, browsers & device types are supported.',
    'index.browsers.desktop_and_android' => 'Desktop & Android',
    'index.browsers.windows' => 'Windows',
    'index.browsers.macos_and_ios' => 'MacOS & IOS',
    'index.browsers.android' => 'Android',

    'index.steps.one' => 'Easy setup & integration',
    'index.steps.one_text' => 'Start collecting push subscribers within minutes.',
    'index.steps.two' => 'We respect your data',
    'index.steps.two_text' => 'Yours always. Deletable anytime.',
    'index.steps.three' => 'Private, safe & compliant',
    'index.steps.three_text' => 'We respect all modern privacy and tracking regulations.',

    'index.stats' => '<span class=\'text-primary-400\'>%1$s+ websites</span> with more than <span class=\'text-primary-400\'>%2$s+ subscribers</span> trust us for delivering web push notifications.',

    'index.notifications_handlers.header' => 'New subscribers notifications',
    'index.notifications_handlers.subheader' => 'Countless notification integrations for all your needs.',

    'index.widget.header' => 'Prompt widget',
    'index.widget.subheader' => 'The ultimate web push notifications widget for your visitors to subscribe with ease.',

    'index.button.header' => 'Action button',
    'index.button.subheader' => 'The most advanced push notifications status button for subscribing and unsubscribing.',

    'index.customizability.header' => 'Advanced customizability',
    'index.customizability.subheader' => 'Every setting you can imagine and need for widgets and buttons.',

    'index.domains.header' => 'Custom domains',
    'index.domains.subheader' => 'Connect your own domain to get a custom pixel JS code link.',

    'index.custom_parameters.header' => 'Custom parameters',
    'index.custom_parameters.subheader' => 'Dynamically tag your subscribers with custom data.',

    'index.export.header' => 'Data export',
    'index.export.subheader' => 'Export your data to CSV, JSON or PDF with a click of a button.',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Integrate web push notifications in your websites within minutes.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',

    'api_documentation.notification_handlers' => 'Notification handlers',
    'api_documentation.notifications_handlers_ids' => 'Notification handler ids',
    'api_documentation.subscribers_statistics' => 'Subscribers statistics',
    'api_documentation.subscribers_statistics.start_date' => 'Start date in <code>Y-m-d</code> format.',
    'api_documentation.subscribers_statistics.end_date' => 'End date in <code>Y-m-d</code> format.',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',

    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',
];
